package httpserver

import (
	"context"
	"github.com/go-chi/chi/v5"
	"net/http"
	"time"
)

const (
	readTimeout  = 5 * time.Second
	writeTimeout = 30 * time.Second
)

type Server struct {
	addr string
	mux  *chi.Mux
}

func NewHTTP(addr string) *Server {
	return &Server{
		addr: addr,
		mux:  chi.NewMux(),
	}
}

func (s *Server) Addr() string {
	return s.addr
}

func (s *Server) Bind(method, pattern string, h http.HandlerFunc) {
	s.mux.Method(method, pattern, h)
}

func (s *Server) Handle(pattern string, h http.Handler) {
	s.mux.Handle(pattern, h)
}

func (s *Server) Mux() *chi.Mux {
	return s.mux
}

func (s *Server) Run(ctx context.Context) error {
	httpSrv := http.Server{
		Addr:         s.addr,
		Handler:      s.mux,
		ReadTimeout:  readTimeout,
		WriteTimeout: writeTimeout,
	}
	go func(ctx context.Context) {
		<-ctx.Done()
		_ = httpSrv.Close()
	}(ctx)
	return httpSrv.ListenAndServe()
}
