package metrics

import "a.yandex-team.ru/infra/hmserver/pkg/yasmclient"

var DefaultBins = []float64{.01, .025, .05, .1, .25, .5, .75, 1.0, 2.5, 5.0, 7.5, 10.0}

type Bucket struct {
	Bin float64
	V   float64
}

func FmtBucketsPush(buckets []Bucket) [][]float64 {
	fmted := make([][]float64, len(buckets))
	for i, b := range buckets {
		fmted[i] = []float64{b.Bin, b.V}
	}
	return fmted
}

type Histogram struct {
	Name    string
	buckets []Bucket
}

func NewHistogram(name string, bins []float64) *Histogram {
	if bins == nil {
		bins = DefaultBins
	}
	b := make([]Bucket, len(bins))
	for i, bin := range bins {
		b[i].Bin = bin
	}
	return &Histogram{Name: name, buckets: b}
}

func (h *Histogram) FmtPush() yasmclient.YasmValue {
	return yasmclient.YasmValue{
		Name:  h.Name,
		Value: FmtBucketsPush(h.buckets),
	}
}

func (h *Histogram) Observe(v float64) {
	for i := range h.buckets {
		b := &h.buckets[i]
		if v <= b.Bin {
			b.V += v
			break
		}
	}
}

func WithTags(name string, tags map[string]string) string {
	tagsPrefix := ""
	for tagName, tag := range tags {
		tagsPrefix += tagName + "=" + tag + ";"
	}
	return tagsPrefix + name
}

type Gauge struct {
	Name  string
	Value float64
}

func NewGauge(name string) *Gauge {
	return &Gauge{Name: name}
}

func (n *Gauge) Set(val float64) {
	n.Value = val
}

func (n *Gauge) FmtPush() yasmclient.YasmValue {
	return yasmclient.YasmValue{
		Name:  n.Name,
		Value: n.Value,
	}
}
