package randutil

import (
	"math/rand"
	"time"
)

func NewEnforcer() *Enforcer {
	r := rand.New(rand.NewSource(time.Now().UnixNano()))
	return &Enforcer{
		genRandFloat: func() float64 {
			return r.Float64()
		},
	}
}

type Enforcer struct {
	genRandFloat func() float64
}

func (e *Enforcer) Force() bool {
	return e.genRandFloat() < 0.01
}
