package randutil

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestEnforcer_Force_ReturnsTrue(t *testing.T) {
	e := &Enforcer{
		genRandFloat: func() float64 {
			return 0.001
		},
	}
	assert.True(t, e.Force(), "should return true if value less then 0.01")
}

func TestEnforcer_Force_ReturnsFalse(t *testing.T) {
	e := &Enforcer{
		genRandFloat: func() float64 {
			return 0.4
		},
	}
	assert.False(t, e.Force(), "should return true if value more then 0.01")
}

func TestEnforcer_Force_ReturnsFalseInCornerCase(t *testing.T) {
	e := &Enforcer{
		genRandFloat: func() float64 {
			return 0.01
		},
	}
	assert.False(t, e.Force(), "should return true if value eq to 0.01")
}
