package server

import (
	"context"
	"log"
	"time"
)

type GC struct {
	recordsTTL time.Duration
	timeout    time.Duration
	limit      int
	m          *Manager
	l          *log.Logger
}

func CreateGC(recordsTTL, timeout time.Duration, limit int, l *log.Logger, m *Manager) *GC {
	return &GC{
		recordsTTL: recordsTTL,
		timeout:    timeout,
		limit:      limit,
		l:          l,
		m:          m,
	}
}

func (gc *GC) Sync(ctx context.Context) error {
	gc.RemoveOldReports(ctx)
	return nil
}

func (gc *GC) RemoveOldReports(ctx context.Context) {
	ctx, cancel := context.WithTimeout(ctx, gc.timeout)
	gc.l.Println("gc running...")
	defer cancel()
	start := time.Now()
	removedCount, _ := gc.m.RemoveReportsOlder(ctx, gc.recordsTTL, gc.limit)
	gc.l.Printf("%d reports collected by gc in %s\n", removedCount, time.Since(start).String())
}
