package main

import (
	"a.yandex-team.ru/infra/hmserver/pkg/reporter/client"
	pb "a.yandex-team.ru/infra/hmserver/proto"
	yasaltpb "a.yandex-team.ru/infra/hostctl/proto"
	"fmt"
	"github.com/golang/protobuf/ptypes"
	"github.com/spf13/cobra"
	"log"
	"math/rand"
	"os"
	"strings"
	"time"
)

var ss = "tgnmrtbalnzfqirkvaxkrowcwwoady\niqcopajvrqghnryxgwpoymkysajtqc\ninxruxatupnciabascvtyazkecsdnf\nugdumlvwswvrmcqlqtvsdwzptaxdhu\nuovwipswlrojuuzdysamdkahdlswcx\ndaftlnamlqosiqtswnkyxemnplrlja\npgwbjcbfafwazothypqydfbcnwsdyg\ncpimgwidofhznryzbgybwtqvalqkmy\npoxsdsecpgxcjlfbhmbewatthphfqm\nmumoybetbkczvsqsnuvtixfxmhygar\ncfwdetkszppfojsbgllwkwxhefsref\nboygvidndllhzaqqxbnxtclokdmxye\nyigsjwtvcxddozepgoqdsulfezgcwm\nqbjwzxtzdqdfkedweqdyxnthmehsav\nsozryfscxrwggvttpxmnpfkfjnikoi\nmtkxhrunlzukrcsmmvxkzndtkiijsa\ndxpgabsoozglnnehixantnynhgplen\nbvnftafvdfytqljhtahudoftuvppzm\nqfrbxtywriysdnolwedydfncauzmwi\nfqdvwqvutbeuqqigalrsipqgcgijsa\nadrfpxukneicsouusmghnbhxyrwcdi\niwavssicnpaaiinokhbfwnppqpmhro\nipjmnvcpdzsvgyxzqvyskeagmnzfft\nimnaxkifvmpyfwdayiiwwwcdunlmrb\noepqwfrxrwdkskvyimkzyhsipoegop\nscwvkskvhttxmthptfzepfihklhznf\nyvfhjeaxvahwfvcgbrbsgvcgmmlgcx\noouptdhwnhbayjgxfiutokewqxlufm\nlnicaucfsqybszozjvkohonybiqylu\nrjaugxxoccvlttvjdtsnnyxcxsvtuk\nwurgyylfpimuhzaejrsdrsdgewtyul\narvgpqcchxlykiajvzqpldwvrczwsa\nsrrliqqusntkmmlwbpljwhxcofiscz\nfeesgrxcuvzpvluxejhgszsdikrdby\nlzskipijsaafosavbnfoloqazufmyb\neydmxiqcgwdmeqkjqdlfbcuzuoqglo\nmstisxskrjtnnmbqgteiletkeriust\nlmlktrozfjfyvvabkkzfabpwfbsjgc\nylvevqibekplrlgimtqpbtqgyuchrn\ncojhigdfkfkjapbpkmmmdksxjnvdax\nblibzzzoetferzvbonqqhhvisaluez\ntnnmxoidupcstygbtlwkruzehhwmiu\nroqhqrmsqyyjqatrhryimsgdtnsptp\ndtmjziwpuggtzafssvkdpzicywypae\nvqdpylbmifdbizgiqyhshicbrxyyvj\nsvligclstamdhkraseieyzliixdgwt\nwvkvypflrrdpibzaznpdhcfheyicyd\nxopotvkxcbtmmwpaazqriohalemggj\nhhmxudpigfphbqqecddwlkiwtowymp\nkfdlachaqitwccrdydkdtncjugaofw\n"

func getRecord(i, hi int) *pb.Unit {
	strs := strings.Split(ss, "\n")
	return &pb.Unit{
		Node:           getHostname(hi),
		Name:           strs[(i+rand.Int())%50],
		Version:        strs[(i+rand.Int())%50],
		Stage:          strs[(i+rand.Int())%50],
		Kind:           strs[(i+rand.Int())%50],
		Ready:          getOk(),
		LastTransition: ptypes.TimestampNow(),
	}
}

func getOk() pb.Status {
	r := rand.Float64()
	if r < 0.05 {
		return pb.Status_FALSE
	}
	return pb.Status_TRUE
}

func getUniqUnit(i int, suffix string) string {
	return fmt.Sprintf("%09d", i)
}

func getHostname(i int) string {
	first := i / 10000
	second := i % 10000
	return fmt.Sprintf("kek%d-%04d.search.yandex.net", first, second)
}

func Execute() {
	var rootCmd = &cobra.Command{
		Use: "hm-reporter-load",
	}
	addresses := make([]string, 0)
	getClient := func() *client.Reporter {
		return client.NewClusterReporter(addresses)
	}
	rps := 10
	offset := 0
	count := 1000
	cmdSpam := &cobra.Command{
		Use:   "spam",
		Short: "Start reporter server",
		Run: func(cmd *cobra.Command, args []string) {
			c := getClient()
			for {
				for i := offset; i < offset+count; i++ {
					rs := make([]*pb.Unit, 50)
					for j := 0; j < 50; j++ {
						rs[j] = getRecord(j, i)
					}
					go func() {
						err := c.SendReport(rs, &yasaltpb.HostInfo{Mtime: ptypes.TimestampNow()}, ptypes.TimestampNow())
						if err != nil {
							log.Println(err.Error())
						}
					}()
					s := 1000 / rps
					time.Sleep(time.Duration(s) * time.Millisecond)
				}
			}
		},
	}

	cmdSpam.Flags().IntVar(&rps, "rps", 10, "rps")
	cmdSpam.Flags().IntVar(&offset, "offset", 0, "offset")
	cmdSpam.Flags().IntVar(&count, "count", 1000, "count")
	rootCmd.PersistentFlags().StringArrayVar(&addresses, "address", []string{"localhost:8080"}, "address to listen to")

	rootCmd.AddCommand(cmdSpam)

	if err := rootCmd.Execute(); err != nil {
		log.Println(err)
		os.Exit(1)
	}
}
