# coding: utf8
import app

from flask import json


@app.host_metrics.route("/")
@app.host_metrics.route("/api")
@app.host_metrics.route("/hostcpu")
def api():
    stats = app.collector.stats()

    responce_body = []
    for _, signal, value in stats:
        responce_body.append([signal, value])

    return app.host_metrics.response_class(
        response=json.dumps(responce_body),
        status=200,
        mimetype='application/json'
    )
