package list

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/stretchr/testify/assert"
	"testing"
)

func Test_fmtNames(t *testing.T) {
	h := pb.HostctlState{}
	h.Slots = []*pb.Slot{
		{Name: "lldpd"},
		{Name: "sshd"},

		{Name: "ebpf-agent"},
		{Name: "yasm-agent"},

		{Name: "yandex-coroner"},
		{Name: "yandex-rtc-duty-perms"},

		{Name: "systemd-sysctl"},
	}
	want := `ebpf-agent
lldpd
sshd
systemd-sysctl
yandex-coroner
yandex-rtc-duty-perms
yasm-agent`
	assert.Equal(t, fmtNames(&h), want)
}
