package main

import (
	"github.com/spf13/cobra"
	"reflect"
	"runtime"
	"testing"

	"a.yandex-team.ru/infra/hostctl/internal/cmdutil"
)

func TestRegister(t *testing.T) {
	cmd := &cmdutil.RootCmd{
		Use:  "hostctl",
		Long: "RTC host control",
	}
	Register(cmd)
	cmds := (*cobra.Command)(cmd).Commands()
	v := make(map[string]string)
	for _, c := range cmds {
		n := c.Name()
		if first, ok := v[n]; ok {
			t.Fatalf("conflicted cmd '%s':\n%s\n%s", n, nameOf(c.Run), first)
		}
		v[n] = nameOf(c.Run)
	}
}

func nameOf(f interface{}) string {
	v := reflect.ValueOf(f)
	if rf := runtime.FuncForPC(v.Pointer()); rf != nil {
		return rf.Name()
	}
	return ""
}
