package manage

import (
	"context"
	"fmt"
	"testing"
	"time"
)

func TestSetupWatchdog(t *testing.T) {
	ctx, cancel := context.WithTimeout(context.Background(), time.Minute)
	var out string
	watchdog = watchdogCtx{
		ctx: ctx,
		fatalf: func(f string, arg ...interface{}) {
			out = fmt.Sprintf(f, arg...)
		},
	}
	now := time.Now()
	rctx, rcancel := setupWatchdog(time.Second)
	dl, ok := rctx.Deadline()
	if !ok {
		t.Errorf("deadline should be ok")
	}
	now2 := now.Add(2 * time.Second)
	if !(dl.Before(now2) && dl.After(now)) {
		t.Errorf("deadline should be between %s and %s, got %s", now, now2, dl)
	}
	rcancel()
	if out != "" {
		t.Errorf("watchdog triggered with message: %s. It shouldnt.", out)
	}
	cancel()

	ctx, cancel = context.WithTimeout(context.Background(), time.Minute)
	watchdog = watchdogCtx{
		ctx: ctx,
		fatalf: func(f string, arg ...interface{}) {
			out = fmt.Sprintf(f, arg...)
		},
	}

	_, _ = setupWatchdog(time.Millisecond)
	//Set long enough sleep, as test maybe flaky with small values
	time.Sleep(50 * time.Millisecond)
	if out == "" {
		t.Errorf("watchdog should be triggered, but it is not (empty output)")
	}
	cancel()
}
