package remove

import (
	"a.yandex-team.ru/infra/hostctl/pkg/hostinfo"
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"a.yandex-team.ru/infra/hostctl/rpc"
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/hostctl/internal/term"
)

type Opts struct {
	Verbose bool
	Include string
}

func Remove() *cobra.Command {
	opts := &Opts{}
	cmd := &cobra.Command{
		Use: "remove <name>",
		Short: "Remove unit. " +
			"Apply absent unit on slot and try completely remove unit from host and state." +
			"If unit still managing by hostctl, will restarted on next run.",
		Args: cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			name := args[0]
			info, err := hostinfo.FromString(opts.Include)
			if err != nil {
				term.FatalE(err)
			}
			logFile, err := cmd.Flags().GetString("logfile")
			if err != nil {
				term.FatalF("cannot get logfile flag: %v", err)
			}
			h := &rpc.HostCtl{}
			request := &pb.RemoveRequest{
				Info:    info,
				Logfile: logFile,
				Verbose: opts.Verbose,
				Name:    name,
			}
			_, err = h.Remove(request)
			if err != nil {
				term.FatalF("cannot get logfile flag: %v", err)
			}
		},
	}
	flags := cmd.Flags()
	flags.BoolVarP(&opts.Verbose, "verbose", "v", false, "verbose output")
	flags.StringVar(&opts.Include,
		"include",
		opts.Include,
		`host include info source:
* '<env>' to parse from HOST_INCLUDE env var
* '/some/path/to/host.json' to read from manually crafted json (not implemented)
* '<empty>' will read ya-salt spec and extract host includes from it`)
	return cmd
}
