package render

import (
	"fmt"
	"log"
	"strings"

	"a.yandex-team.ru/infra/hostctl/pkg/render"
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/hostctl/pkg/render/rtcutil"
)

type RenderOpts struct {
	Filename string
	Cluster  string
	Node     string
}

func Render() *cobra.Command {
	opts := &RenderOpts{}
	cmd := &cobra.Command{
		Use:   "render <filename>",
		Short: "Render hostctl unit based on from host_info hm-reporter",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			renderer, err := rtcutil.NewHostRendererForCluster(opts.Cluster)
			if err != nil {
				log.Fatalf("Cannot create RTC host renderer: %v", err)
			}
			opts.Filename = args[0]
			s, err := render.NewLocalRenderStorage(opts.Filename)
			if err != nil {
				log.Fatalf("Cannot create render storage: %v", err)
			}
			unitName := render.UnitNameFromPath(opts.Filename)
			unit, err := renderer.UnitFromStorage(s, unitName, opts.Node)
			if err != nil {
				log.Fatalf("Cannot render file %s: %v", opts.Node, err)
			}
			pretty, err := unit.Pretty()
			if err != nil {
				log.Fatalf("Cannot prettify output: %v", err)
			}
			fmt.Printf("%s\n", pretty)
		},
	}

	flags := cmd.Flags()
	flags.StringVarP(&opts.Node, "node", "n", "", "Node of host_info")
	flags.StringVarP(&opts.Cluster, "cluster", "c", "",
		fmt.Sprintf("HM reporter cluster: one of [%s]", strings.Join(rtcutil.GetClusterList(), ", ")))
	return cmd
}
