package state

import (
	"fmt"
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/hostctl/internal/term"
	"a.yandex-team.ru/infra/hostctl/internal/units/storage"
	"google.golang.org/protobuf/encoding/protojson"
)

func State() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "print-state",
		Short: "Cat hostctl protobuf state",
		Args:  cobra.NoArgs,
		Run: func(cmd *cobra.Command, args []string) {
			s := storage.New(storage.StateFile)
			state, err := s.Load()
			if err != nil {
				term.FatalE(err)
			}
			buf, err := (&protojson.MarshalOptions{Multiline: true}).Marshal(state)
			if err != nil {
				term.FatalE(err)
			}
			fmt.Printf("%s\n", buf)
		},
	}
	return cmd
}
