package version

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

func Version() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "version",
		Short: "Show hostctl build info",
		Args:  cobra.NoArgs,
		Run: func(cmd *cobra.Command, args []string) {
			fmt.Printf("rev: %s\n", buildinfo.Info.SVNRevision)
			fmt.Printf("date: %s\n", buildinfo.Info.Date)
			fmt.Printf("commit: '%s%s'\n", "https://a.yandex-team.ru/arc/commit/", buildinfo.Info.SVNRevision)
		},
	}
	return cmd
}
