package killswitch

import (
	"a.yandex-team.ru/infra/hostctl/internal/unit"
	"a.yandex-team.ru/infra/hostctl/internal/unit/kind"
	"fmt"
	"log"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/hostctl/pkg/render"
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"a.yandex-team.ru/infra/orly/go/orly/client"
	orlypb "a.yandex-team.ru/infra/orly/proto"
)

func Killswitch() *cobra.Command {
	orlyURL := client.URLProduction
	cmd := &cobra.Command{
		Use:   "killswitch <filename>",
		Short: "Set orly maxAllowed to 0 for hostctl unit",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			f, err := os.Open(args[0])
			if err != nil {
				log.Fatal(err)
			}
			defer f.Close()
			renderer, err := render.NewWithTemplate(f)
			if err != nil {
				log.Fatalf("Failed to create renderer with template %s: %v", args[0], err)
			}
			u, err := renderer.Render(&pb.HostInfo{
				Hostname:      "sas1-4920.search.yandex.net",
				KernelRelease: "4.19.172-41",
			})
			if err != nil {
				log.Fatalf("Failed to render file on virtual node: %v", err)
			}
			k := kind.Kind(u.RevMeta().Kind)
			name := u.Name()
			ruleName := unit.FmtRule(k, name)
			orly := client.NewClient(orlyURL)
			resp, err := orly.GetRule(&orlypb.GetRuleRequest{RuleId: ruleName})
			if err != nil {
				log.Fatalf("Failed to get orly rule %s: %v", ruleName, err)
			}
			rule := resp.Rule
			if rule == nil {
				log.Fatalf("Rule %s does not exists", ruleName)
			}
			rule.Spec.MaxAllowed = 0
			_, err = orly.CreateRule(&orlypb.CreateRuleRequest{Rule: rule})
			if err != nil {
				log.Fatalf("Failed to update rule %s: %v", ruleName, err)
			}
			fmt.Printf("Successfully set maxAllowed to 0 for rule %s\n", ruleName)
		},
	}
	flags := cmd.Flags()
	flags.StringVar(&orlyURL, "orly-url", client.URLProduction, fmt.Sprintf("ORLY URL (default: %s)", client.URLProduction))
	return cmd
}
