package location

import (
	"fmt"
	"strings"
)

type Location string
type Locations []Location

const (
	Prestable Location = "PRESTABLE"
	SAS       Location = "SAS"
	VLA       Location = "VLA"
	MAN       Location = "MAN"
	MSK       Location = "MSK"
	ALL       Location = "ALL"
)

var (
	Branches = map[Location]string{
		Prestable: "prestable",
		SAS:       "sas",
		VLA:       "vla",
		MAN:       "man",
		MSK:       "msk",
	}
	Clusters = Locations{Prestable, SAS, VLA, MAN, MSK}
)

func FmtClusters() string {
	strs := make([]string, len(Clusters))
	for i := 0; i < len(Clusters); i++ {
		strs[i] = string(Clusters[i])
	}
	return strings.Join(strs, ", ")
}

func (l Locations) Valid(loc Location) error {
	var found bool
	for i := range Clusters {
		if Clusters[i] == loc {
			found = true
			break
		}
	}
	if !found {
		return fmt.Errorf("location \"%s\" is invalid, valid locations: [%s]", loc, FmtClusters())

	}
	return nil
}
