package util

import (
	"fmt"
	"os"
	"syscall"
)

func RunEditor(editor, path string) error {
	pa := &syscall.ProcAttr{
		Dir:   ".",
		Env:   os.Environ(),
		Files: []uintptr{os.Stdin.Fd(), os.Stdout.Fd(), os.Stderr.Fd()},
		Sys:   nil,
	}
	pid, err := syscall.ForkExec(editor, []string{editor, path}, pa)
	if err != nil {
		return err
	}
	var ws syscall.WaitStatus
	_, err = syscall.Wait4(pid, &ws, 0, nil)
	if err != nil {
		return err
	}
	status := ws.ExitStatus()
	if status != 0 {
		return fmt.Errorf("editor %s exited with: %d", editor, status)
	}
	return nil
}
