package util

import (
	"a.yandex-team.ru/library/go/core/log"
	azap "a.yandex-team.ru/library/go/core/log/zap"
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

func NewLogger(level log.Level) log.Logger {
	cfg := zap.Config{
		Level:    zap.NewAtomicLevelAt(azap.ZapifyLevel(level)),
		Encoding: "console",
		EncoderConfig: zapcore.EncoderConfig{
			MessageKey: "msg",
		},
		OutputPaths:      []string{"stdout"},
		ErrorOutputPaths: []string{"stderr"},
	}
	l, _ := azap.New(cfg)
	return l
}
