package changelog

import (
	"a.yandex-team.ru/infra/hostctl/internal/fmtutil"
	"a.yandex-team.ru/library/go/core/log"
	"bytes"
	"fmt"
	"gopkg.in/yaml.v2"
)

type Event struct {
	Event   string `yaml:"event"`
	Message string `yaml:"status"`
}

type ChangeLog struct {
	Events []Event `yaml:"logs"`
}

func New() *ChangeLog {
	return &ChangeLog{Events: make([]Event, 0)}
}

func (ch *ChangeLog) Add(event, message string) *AddCallback {
	e := Event{event, message}
	ch.Events = append(ch.Events, e)
	return &AddCallback{e: e}
}

type AddCallback struct {
	e Event
}

func (c *AddCallback) Log(l log.Logger) {
	l.Infof("Running %s:%s", c.e.Event, c.e.Message)
}

func (ch *ChangeLog) Fmt(name, revID, desc string) (string, error) {
	header := ""
	if len(revID) > 11 {
		header = fmt.Sprintf(" %s rev.%.11s (%s) ", name, revID, desc)
	}
	b := &bytes.Buffer{}
	b.Write(fmtutil.FmtLine(header))
	b.WriteByte('\n')
	if len(ch.Events) == 0 {
		b.WriteString("**not** changed\n")
	} else {
		if err := yaml.NewEncoder(b).Encode(ch); err != nil {
			return "", fmt.Errorf("failed to marshal changelog: %w", err)
		}
	}
	b.Write(fmtutil.FmtLine(""))
	return b.String(), nil
}
