package changelog

import (
	"github.com/stretchr/testify/assert"
	"reflect"
	"testing"
)

func TestChangelog_Add(t *testing.T) {
	ch := ChangeLog{}
	ch.Add("pkg.installed", "ntp=1.4-dsg6")
	ch.Add("pkg.removed", "chrony")
	if l := len(ch.Events); l != 2 {
		t.Fatalf("Invalid changelog len=%d, expected 2", l)
	}
	expected := []Event{
		{Event: "pkg.installed", Message: "ntp=1.4-dsg6"},
		{Event: "pkg.removed", Message: "chrony"},
	}
	if !reflect.DeepEqual(ch.Events, expected) {
		t.Fatalf("Got unexpected changelog content: \n%+v", ch.Events)
	}
}

func TestFmtChangeLog(t *testing.T) {
	ch := New()
	ch.Add("pkg.install", "p=1")
	name := "test"
	revID := "aaaaaaaaaaaaaaaaaa"
	desc := "current"
	got, err := ch.Fmt(name, revID, desc)
	if err != nil {
		t.Error(err)
	}
	expected := `------------ test rev.aaaaaaaaaaa (current) ------------
logs:
- event: pkg.install
  status: p=1
--------------------------------------------------------`
	assert.Equal(t, expected, got)
}
