package definitions

import (
	"io"
)

type NamedReader interface {
	io.Reader
	Name() string
}

func New(r io.Reader, path string) *definition {
	return &definition{
		Reader: r,
		p:      path,
	}
}

/*
definition is wrapper over buffer
for unit definition storing with unit source path
*/
type definition struct {
	io.Reader
	p string
}

func (d *definition) Name() string {
	return d.p
}
