package environment

import (
	"io/fs"
	"os"

	"a.yandex-team.ru/infra/hostctl/internal/engine/template"
	"a.yandex-team.ru/library/go/core/log"
)

func New(l log.Logger, overrides []string, repoOverride string) *env {
	return &env{
		l:             l,
		fs:            os.DirFS("/"),
		userOverrides: overrides,
		repoRoot:      repoOverride,
	}
}

type Environment interface {
	Templates() map[string]template.Template
}

type env struct {
	l  log.Logger
	fs fs.FS

	userOverrides []string
	repoRoot      string

	unitNames []string
}

func (e *env) WithUnitNames(names ...string) *env {
	e.unitNames = names
	return e
}

/*
Templates from env:
 * Make Path from default production dirs and repo/dirs userOverrides
 * Read units definitions from path's origins
 * Parse templates from definitions
*/
func (e *env) Templates() map[string]*template.Template {
	origins := Path(e.fs, e.userOverrides, e.repoRoot)
	defs := Read(e.l, e.fs, origins, e.unitNames)
	templates := make(map[string]*template.Template)
	for name, d := range defs {
		templates[name] = Parse(e.l, d)
	}
	return templates
}
