package expire

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"fmt"
	"time"
)

const (
	annExpired    = "hostctl/expire-time" // K8s style of annotations.
	FmtExpireTime = "2006-01-02 15:04:05" // Public for clients to use.
)

// Expired checks if unit has expire annotation. Can be used for temporary overrides.
func Expired(meta *pb.ObjectMeta) (bool, error) {
	s := meta.Annotations[annExpired]
	if len(s) == 0 {
		return false, nil
	}
	t, err := time.Parse(FmtExpireTime, s)
	if err != nil {
		return false, fmt.Errorf("invalid annotations['%s'] format: %w", annExpired, err)
	}
	return t.Before(time.Now()), nil
}
