package expire

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/stretchr/testify/assert"
	"testing"
	"time"
)

func Test_isExpired(t *testing.T) {
	meta := &pb.ObjectMeta{
		Annotations: make(map[string]string),
	}
	// No annotations case
	expired, err := Expired(meta)
	assert.NoError(t, err)
	assert.False(t, expired)
	// Invalid annotation case
	meta.Annotations[annExpired] = "sometime"
	expired, err = Expired(meta)
	assert.Error(t, err)
	assert.False(t, expired)
	// Expired case
	meta.Annotations[annExpired] = time.Time{}.Format(FmtExpireTime)
	expired, err = Expired(meta)
	assert.NoError(t, err)
	assert.True(t, expired)
	// Not expired case
	meta.Annotations[annExpired] = time.Now().Add(100 * time.Minute).Format(FmtExpireTime)
	expired, err = Expired(meta)
	assert.NoError(t, err)
	assert.False(t, expired)
}
