package bench

import (
	"a.yandex-team.ru/infra/hostctl/internal/engine/hostctx"
	hostpb "a.yandex-team.ru/infra/hostctl/proto"
	"fmt"
	"runtime"
	"strings"
	"testing"
)

// Max value: 100000
func genHostlist(count int) []string {
	hosts := make([]string, count)
	for i := 0; i < count; i++ {
		hosts[i] = fmt.Sprintf("sas1-%5d.search.yandex.net", i)
	}
	return hosts
}

func fmtHostlist(hosts []string) string {
	return fmt.Sprintf("h['%s']", strings.Join(hosts, "', '"))
}

var (
	hi = &hostpb.HostInfo{
		Hostname:      "man1-8186.search.yandex.net",
		KernelRelease: "4.19.172-41",
		WalleProject:  "rtc-prestable",
		WalleTags: []string{
			"rtc",
			"rtc.automation-enabled",
			"rtc.cohabitation-enabled",
			"rtc.gpu-none",
			"rtc.reboot_segment-prestable-def",
			"rtc.scheduler-gencfg",
			"rtc.stage-prestable",
			"rtc_network",
			"runtime",
			"search",
			"skynet_installed",
			"tentacles_monitored",
			"yasm_monitored",
		},
	}
	vars = map[string]interface{}{"k": "v"}
)

func BenchmarkExecExpr_Hostlist_1(b *testing.B) {
	benchmarkExecExprHostlistN(1, 4, b)
}

func BenchmarkExecExpr_Hostlist_10(b *testing.B) {
	benchmarkExecExprHostlistN(10, 4, b)
}

func BenchmarkExecExpr_Hostlist_100(b *testing.B) {
	benchmarkExecExprHostlistN(100, 4, b)
}

func BenchmarkExecExpr_Hostlist_1000(b *testing.B) {
	benchmarkExecExprHostlistN(1000, 4, b)
}
func BenchmarkExecExpr_Hostlist_10000(b *testing.B) {
	benchmarkExecExprHostlistN(10000, 4, b)
}

func BenchmarkExecExpr_Hostlist_100000(b *testing.B) {
	benchmarkExecExprHostlistN(100000, 4, b)
}

func BenchmarkExecExpr_Hostlist_1000_64p(b *testing.B) {
	benchmarkExecExprHostlistN(1000, 64, b)
}
func BenchmarkExecExpr_Hostlist_10000_64p(b *testing.B) {
	benchmarkExecExprHostlistN(10000, 64, b)
}

func BenchmarkExecExpr_Hostlist_100000_64p(b *testing.B) {
	benchmarkExecExprHostlistN(100000, 64, b)
}

func benchmarkExecExprHostlistN(i int, procs int, b *testing.B) {
	runtime.GOMAXPROCS(procs)
	env, opts, _ := hostctx.CreateEnv(hi, vars)
	hosts := genHostlist(i)
	expr := fmtHostlist(hosts)

	// Reset timer after initialization
	// We want to benchmark only expr evaluation
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		b.StartTimer()
		_, _ = hostctx.ExecExpr(env, opts, expr, vars)
		b.StopTimer()
	}
}
