package celhelpers

import (
	"fmt"
	"strconv"
	"strings"
)

type KernelRelease struct {
	Release string
	Major   int64
	Minor   int64
	Patch   int64
	Build   int64
}

func ParseKernelRelease(kernel string) (*KernelRelease, error) {
	split := strings.Split(kernel, "-")
	build := ""
	if len(split) == 2 {
		build = split[1]
	}
	split = strings.Split(split[0], ".")
	if len(split) != 3 {
		return nil, fmt.Errorf("invalid kernel release value: %s", kernel)
	}
	major, minor, patch := split[0], split[1], split[2]
	buildInt, err := strconv.ParseInt(build, 10, 64)
	if err != nil {
		buildInt = -1
	}
	majorInt, err := strconv.ParseInt(major, 10, 64)
	if err != nil {
		majorInt = -1
	}
	minorInt, err := strconv.ParseInt(minor, 10, 64)
	if err != nil {
		minorInt = -1
	}
	patchInt, err := strconv.ParseInt(patch, 10, 64)
	if err != nil {
		patchInt = -1
	}
	return &KernelRelease{
		Release: kernel,
		Major:   majorInt,
		Minor:   minorInt,
		Patch:   patchInt,
		Build:   buildInt,
	}, nil
}

func (k *KernelRelease) ToMap() map[string]interface{} {
	return map[string]interface{}{
		"release": k.Release,
		"major":   k.Major,
		"minor":   k.Minor,
		"patch":   k.Patch,
		"build":   k.Build,
	}
}
