package celhelpers

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func Test_parseKernelRelease(t *testing.T) {
	got, err := ParseKernelRelease("4.19.119-30.2")
	if err != nil {
		t.Error(err)
	}
	assert.Equal(t, got.Major, int64(4))
	assert.Equal(t, got.Minor, int64(19))
	assert.Equal(t, got.Patch, int64(119))
	assert.Equal(t, got.Build, int64(-1))
	assert.Equal(t, got.Release, "4.19.119-30.2")
}

func Test_parseKernelRelease_invalidValue(t *testing.T) {
	_, err := ParseKernelRelease("invalid")
	assert.Errorf(t, err, "invalid kernel release value: invalid")
}

func Test_parseKernelRelease_notFloatBuild(t *testing.T) {
	got, err := ParseKernelRelease("4.19.143-cfsdbg+")
	if err != nil {
		t.Error(err)
	}
	assert.Equal(t, got.Build, int64(-1))
}

func Test_parseKernelRelease_upstreamVersion(t *testing.T) {
	got, err := ParseKernelRelease("5.4.105")
	if err != nil {
		t.Error(err)
	}
	assert.Equal(t, got.Major, int64(5))
	assert.Equal(t, got.Minor, int64(4))
	assert.Equal(t, got.Patch, int64(105))
	assert.Equal(t, got.Build, int64(-1))
}
