package funcs

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func Test_parseKernelRelease(t *testing.T) {
	got, err := parseKernelRelease("4.19.119-30.2")
	if err != nil {
		t.Error(err)
	}
	assert.Equal(t, got.major, "4")
	assert.Equal(t, got.minor, "19")
	assert.Equal(t, got.patch, "119")
	assert.Equal(t, got.build, "30.2")
}

func Test_parseKernelRelease_invalidValue(t *testing.T) {
	_, err := parseKernelRelease("invalid")
	assert.Errorf(t, err, "invalid kernel release value: invalid")
}

func Test_parseKernelRelease_emptyBuild(t *testing.T) {
	_, err := parseKernelRelease("4.19.119")
	assert.Errorf(t, err, "invalid kernel release value: 4.19.119")
}
