package environment

import (
	"a.yandex-team.ru/infra/hostctl/internal/engine/definitions"
	"a.yandex-team.ru/infra/hostctl/internal/engine/template"
	"a.yandex-team.ru/library/go/core/log"
)

// Parse templates from buffers return one from most priority origin
func Parse(l log.Logger, defs []definitions.NamedReader) *template.Template {
	for i := len(defs) - 1; i >= 0; i++ {
		def := defs[i]
		l.Debugf("Parsing definition from %s", def.Name())
		t, err := template.Parse(def)
		if err != nil {
			l.Warnf("Failed to parse definition from %s origin: %s", def.Name(), err)
			continue
		}
		return t
	}
	return nil
}
