package executil

import (
	"bytes"
	"context"
	"os/exec"
)

var installQueryResp = "Reading package lists... Done\n" +
	"Building dependency tree       \n" +
	"Reading state information... Done\n" +
	"apt is already the newest version (1.2.32).\n" +
	"The following packages were automatically installed and are no longer required:\n" +
	"  libopts25 libsodium18 libzmq5 ntp python-chardet python-crypto python-dateutil python-jinja2 python-markupsafe python-msgpack python-pycurl python-requests python-six python-systemd python-urllib3 python-yaml\n" +
	"Use 'sudo apt autoremove' to remove them.\n" +
	"0 upgraded, 0 newly installed, 0 to remove and 0 not upgraded."

var installTwoPkgQueryResp = "Reading package lists...\n" +
	"Building dependency tree...\n" +
	"Reading state information...\n" +
	"apt is already the newest version (1.2.32).\n" +
	"The following packages were automatically installed and are no longer required:\n" +
	"  libopts25 libsodium18 libsvn-perl libterm-readkey-perl libyaml-perl libzmq5 ntp python-chardet python-crypto python-dateutil python-jinja2 python-markupsafe python-msgpack python-pycurl python-requests python-six python-systemd python-urllib3 python-yaml\n" +
	"Use 'sudo apt autoremove' to remove them.\n" +
	"Suggested packages:\n" +
	"  gettext-base git-daemon-run | git-daemon-sysvinit git-doc git-el git-email git-gui gitk gitweb git-arch git-cvs git-mediawiki git-svn\n" +
	"The following NEW packages will be installed:\n" +
	"  git\n" +
	"0 upgraded, 1 newly installed, 0 to remove and 47 not upgraded.\n" +
	"Need to get 3,176 kB of archives.\n" +
	"After this operation, 24.1 MB of additional disk space will be used.\n" +
	"Get:1 http://mirror.yandex.ru/ubuntu xenial-security/main amd64 git amd64 1:2.7.4-0ubuntu1.9 [3,176 kB]\n" +
	"Fetched 3,176 kB in 0s (68.0 MB/s)\n" +
	"debconf: unable to initialize frontend: Dialog\n" +
	"debconf: (No usable dialog-like program is installed, so the dialog based frontend cannot be used. at /usr/share/perl5/Debconf/FrontEnd/Dialog.pm line 76, <> line 1.)\n" +
	"debconf: falling back to frontend: Readline\n" +
	"Selecting previously unselected package git.\n" +
	"(Reading database ... 112906 files and directories currently installed.)\n" +
	"Preparing to unpack .../git_1%3a2.7.4-0ubuntu1.9_amd64.deb ...\n" +
	"Unpacking git (1:2.7.4-0ubuntu1.9) ...\n" +
	"Setting up git (1:2.7.4-0ubuntu1.9) ...\n" +
	"W: --force-yes is deprecated, use one of the options starting with --allow instead."

var installUnknownPkgQueryRespSrdout = "Reading package lists... Done\n" +
	"Building dependency tree       \n" +
	"Reading state information... Done"
var installUnknownPkgQueryRespSrderr = "E: Version '1.2.33' for 'apt' was not found"

var failRepairQueryRespStdout = "Reading package lists... Done\n" +
	"Building dependency tree       " +
	"\nReading state information... Done"
var failRepairQueryRespStderr = "E: Version '1.2.33' for 'apt' was not found"

var purgeQueryResp = "Reading package lists...\n" +
	"Building dependency tree...\n" +
	"Reading state information...\n" +
	"The following packages were automatically installed and are no longer required:\n" +
	"  git-man liberror-perl libopts25 libsodium18 libsvn-perl libterm-readkey-perl libyaml-perl libzmq5 ntp python-chardet python-crypto python-dateutil python-jinja2 python-markupsafe python-msgpack python-pycurl python-requests python-six python-systemd python-urllib3 python-yaml\n" +
	"Use 'sudo apt autoremove' to remove them.\n" +
	"The following packages will be REMOVED:\n" +
	"  git* git-svn*\n" +
	"0 upgraded, 0 newly installed, 2 to remove and 48 not upgraded.\n" +
	"After this operation, 25.0 MB disk space will be freed.\n" +
	"(Reading database ... 113568 files and directories currently installed.)\n" +
	"Removing git-svn (1:2.7.4-0ubuntu1.9) ...\n" +
	"Removing git (1:2.7.4-0ubuntu1.9) ...\n" +
	"Purging configuration files for git (1:2.7.4-0ubuntu1.9) ...\n" +
	"Processing triggers for man-db (2.7.5-1) ...\n"

var purgeFailQueryRespStdout = "Reading package lists...\n" +
	"Building dependency tree...\n" +
	"Reading state information...\n" +
	"The following packages were automatically installed and are no longer required:\n" +
	"  git-man liberror-perl libopts25 libsodium18 libsvn-perl libterm-readkey-perl libyaml-perl libzmq5 mdadm ntp python-apt python-chardet python-crypto python-dateutil python-jinja2 python-markupsafe python-msgpack python-pycurl python-requests python-six python-systemd python-urllib3 python-yaml smartmontools\n" +
	"Use 'sudo apt autoremove' to remove them.\n" +
	"The following packages will be REMOVED:\n" +
	"  apt* apt-utils* yandex-search-common-settings*\n" +
	"WARNING: The following essential packages will be removed.\n" +
	"This should NOT be done unless you know exactly what you are doing!\n" +
	"  apt\n" +
	"0 upgraded, 0 newly installed, 3 to remove and 45 not upgraded.\n"

var purgeFailQueryRespStderr = "E: Essential packages were removed and -y was used without --allow-remove-essential."

func FakeOkDpkgRepairQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	return nil
}

func FakeFailDpkgRepairQueryExecutor(ctx context.Context, c *Cmd) error {
	e := "fail"
	c.stdout = bytes.Buffer{}
	c.stderr = bytes.Buffer{}
	c.stderr.WriteString(e)
	return &exec.ExitError{Stderr: []byte(e)}
}

func FakeOkAptRepairQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stdout.WriteString(installQueryResp)
	return nil
}

func FakeFailAptRepairQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stderr = bytes.Buffer{}
	c.stdout.WriteString(failRepairQueryRespStdout)
	c.stderr.WriteString(failRepairQueryRespStderr)
	return &exec.ExitError{Stderr: []byte(failRepairQueryRespStderr)}
}

func FakeOkAptInstallQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stdout.WriteString(installQueryResp)
	return nil
}

func FakeOkAptInstallTwoPkgQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stdout.WriteString(installTwoPkgQueryResp)
	return nil
}

func FakeFailAptInstallQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stderr = bytes.Buffer{}
	c.stdout.WriteString(installUnknownPkgQueryRespSrdout)
	c.stderr.WriteString(installUnknownPkgQueryRespSrderr)
	return &exec.ExitError{Stderr: []byte(installUnknownPkgQueryRespSrderr)}
}

func FakeOkAptPurgeQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stdout.WriteString(purgeQueryResp)
	return nil
}

func FakeFailAptPurgeQueryExecutor(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stderr = bytes.Buffer{}
	c.stdout.WriteString(purgeFailQueryRespStdout)
	c.stderr.WriteString(purgeFailQueryRespStderr)
	return &exec.ExitError{Stderr: []byte(purgeFailQueryRespStderr)}
}
