package executil

import (
	"bytes"
	"context"
	"os/exec"
)

var systemctlStartStdout = "Reading package lists... Done\n" +
	"Building dependency tree       \n" +
	"Reading state information... Done"
var systemctlStartStderr = "E: Version '1.2.33' for 'apt' was not found"

func FakeSystemctlOk(ctx context.Context, c *Cmd) error {
	c.stdout = bytes.Buffer{}
	c.stderr = bytes.Buffer{}
	c.stdout.WriteString("")
	c.stderr.WriteString("")
	return nil
}

func FakeSystemctlIsEnabled(unitFileState string, zeroCode bool) ExecFn {
	return func(ctx context.Context, c *Cmd) error {
		c.stdout = bytes.Buffer{}
		c.stderr = bytes.Buffer{}
		c.stdout.WriteString(unitFileState + "\n")
		c.stderr.WriteString("")
		if zeroCode {
			return nil
		}
		return &exec.ExitError{Stderr: make([]byte, 0)}
	}
}

func FakeSystemctlStatus(output []byte) ExecFn {
	return func(ctx context.Context, c *Cmd) error {
		c.stdout = bytes.Buffer{}
		c.stderr = bytes.Buffer{}
		c.stdout.Write(output)
		c.stderr.WriteString("")
		return nil
	}
}
