package fmtutil

import "bytes"

const lineLen = 56

func FmtLineN(text string, n int) []byte {
	b := &bytes.Buffer{}
	start := (n - len(text)) / 2
	end := (n - len(text)) / 2
	odd := (n-len(text))%2 != 0
	if odd {
		end++
	}
	if start < 4 {
		start = 4
	}
	if end < 4 {
		end = 4
	}
	b.Write(bytes.Repeat([]byte("-"), start))
	b.WriteString(text)
	b.Write(bytes.Repeat([]byte("-"), end))
	return b.Bytes()
}

func FmtLine(text string) []byte {
	return FmtLineN(text, lineLen)
}
