package fmtutil

import (
	"bytes"
	"testing"
)

func Test_fmtLine(t *testing.T) {
	type args struct {
		text string
		n    int
	}
	tests := []struct {
		name string
		args args
		want []byte
	}{{
		name: "simple",
		args: args{
			text: " aa ",
			n:    16,
		},
		want: []byte("------ aa ------"),
	}, {
		name: "odd",
		args: args{
			text: " a ",
			n:    16,
		},
		want: []byte("------ a -------"),
	}, {
		name: "long",
		args: args{
			text: " aaaaaaaaaaa ",
			n:    10,
		},
		want: []byte("---- aaaaaaaaaaa ----"),
	}}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := FmtLineN(tt.args.text, tt.args.n); !bytes.Equal(got, tt.want) {
				t.Errorf("FmtLineN() = %v, want %v", string(got), string(tt.want))
			}
		})
	}
}
