package fmtutil

import (
	"github.com/golang/protobuf/ptypes/timestamp"
	"time"
)

func Time(t time.Time) string {
	return t.Format("2006-01-02 15:04:05")
}

func Timestamp(ts *timestamp.Timestamp) string {
	if ts == nil {
		return "-"
	}
	return Time(time.Unix(ts.Seconds, int64(ts.Nanos)))
}
