package fmtutil

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"fmt"
	"strings"
)

const (
	redTextColor    = "31"
	greenTextColor  = "32"
	yellowTextColor = "33"
	blueTextColor   = "34"
	boldText        = "1"
	dimText         = "2"
)

func colorize(text string, modification ...string) string {
	return fmt.Sprintf("\033[%sm%s\033[0m", strings.Join(modification, ";"), text)
}

func Condition(name string, c *pb.Condition) string {
	b := &strings.Builder{}
	_, _ = fmt.Fprintf(b, "%10s: ", name)
	if c.Status == "True" {
		b.WriteString(colorize("yes", boldText))
	} else if c.Status == "False" {
		b.WriteString(colorize("no ", boldText))
	} else {
		b.WriteString(colorize("unk", boldText))
	}
	// Dim timestamps
	b.Write([]byte("\033[2m"))
	b.WriteString(" (since ")
	b.WriteString(Timestamp(c.TransitionTime))
	b.WriteByte(')')
	b.Write([]byte("\u001B[0m"))
	b.WriteByte('\n')
	if c.Message != "" && c.Message != "OK" {
		b.WriteString("            ") // 12 spaces
		b.WriteString(c.Message)
		b.WriteByte('\n')
	}
	return b.String()
}
