package lockfile

import (
	"fmt"
	"io"
	"os"
)

var openFunc = func(name string, flag int, perm os.FileMode) (LockFile, error) {
	return os.OpenFile(name, flag, perm)
}

type LockFile interface {
	io.Closer
	Fd() uintptr
}

func makeErr(path string, err error) error {
	return fmt.Errorf("cannot obtain exclusive lock on %s: %w", path, err)
}
