package lockfile

import (
	"os"
	"syscall"
)

func New(path string) (LockFile, error) {
	f, err := openFunc(path, os.O_CREATE|syscall.O_EXLOCK|syscall.O_CLOEXEC|syscall.O_NONBLOCK, 0o644)
	if err != nil {
		return nil, makeErr(path, err)
	}
	return f, nil
}
