package lockfile

import (
	"os"
	"syscall"
)

var flockFunc = syscall.Flock

type LinuxLockFile struct {
	f LockFile
}

func New(path string) (LockFile, error) {
	f, err := openFunc(path, os.O_CREATE|syscall.O_CLOEXEC, 0o644)
	if err != nil {
		return nil, makeErr(path, err)
	}
	if err = flockFunc(int(f.Fd()), syscall.LOCK_EX|syscall.LOCK_NB); err != nil {
		return nil, makeErr(path, err)
	}
	return &LinuxLockFile{f}, nil
}

func (f LinuxLockFile) Close() error {
	if err := flockFunc(int(f.f.Fd()), syscall.LOCK_UN|syscall.LOCK_NB); err != nil {
		return err
	}
	return f.f.Close()
}

func (f LinuxLockFile) Fd() uintptr {
	return f.f.Fd()
}
