package lockfile

import (
	"errors"
	"fmt"
	"testing"
)

func TestMakeErr(t *testing.T) {
	e := errors.New("mock")
	err := makeErr("/mock", e)
	if err.Error() != "cannot obtain exclusive lock on /mock: mock" {
		t.Errorf("makeErr should return exact error")
	}
}

func TestNew(t *testing.T) {
	p := fmt.Sprintf("%s/%s", t.TempDir(), "t.lock")
	l, err := New(p)
	if err != nil || l == nil {
		t.Fatalf("should be ok, got err: %v, l: %v", err, l)
	}
	l2, err := New(p)
	if err == nil && l2 != nil {
		t.Errorf("file should be locked")
	}
	_ = l.Close()
	_, err = New(p)
	if err != nil {
		t.Errorf("should be ok")
	}
}
