package orly

import (
	"a.yandex-team.ru/infra/orly/go/orly/client"
	pb "a.yandex-team.ru/infra/orly/proto"
)

type Throttler interface {
	Can(ruleID string, labels map[string]string) error
}

type Orly struct {
	orly     *client.Client
	hostname string
}

func NewOrly(hostname, orlyURL string) *Orly {
	return &Orly{
		orly:     client.NewClient(orlyURL),
		hostname: hostname,
	}
}

func NewNoop() *Noop {
	return &Noop{}
}

func (t *Orly) Can(ruleID string, labels map[string]string) error {
	_, err := t.orly.StartOperation(&pb.OperationRequest{
		Rule:   ruleID,
		Id:     t.hostname,
		Labels: labels,
	})
	if err != nil {
		return err
	}
	return nil
}

type Noop struct {
}

func (t *Noop) Can(ruleID string, labels map[string]string) error {
	return nil
}
