package reporting

import (
	"a.yandex-team.ru/library/go/core/log"

	"a.yandex-team.ru/infra/hmserver/pkg/reporter/client"
	"a.yandex-team.ru/infra/hostctl/internal/units"
	"a.yandex-team.ru/infra/hostctl/internal/units/report"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func Report(rp *ReportParams, h *pb.HostInfo, l log.Logger) {
	if rp.SkipReporting {
		return
	}
	hmRep := report.NewNoopReporter()
	if len(rp.ReporterAddrs) > 0 {
		hmRep = report.NewReporter(client.NewClusterReporter(rp.ReporterAddrs), &report.Config{Hostname: h.Hostname}, l, rp.Ctype)
	}
	yasmRepBuilder := report.NewNoopYasmReporter
	if rp.YasmEnv == pb.EnvType_REAL {
		yasmRepBuilder = report.NewYasmReporter
	}
	jugglerRep := report.NewNoopJugglerReporter(l, &report.Config{Hostname: h.Hostname})
	if rp.YasmEnv == pb.EnvType_REAL {
		jugglerRep = report.NewJugglerReporter(l, &report.Config{Hostname: h.Hostname})
	}
	_ = units.ReportState(l, h, hmRep, jugglerRep, yasmRepBuilder, rp.Ctype)
}
