package slot

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

/* Unit metadata derived from incoming template */
type Meta struct {
	*pb.SlotMeta
}

func MetaFromProto(m *pb.SlotMeta) *Meta {
	return &Meta{
		SlotMeta: m,
	}
}

type Stage string

func (m *Meta) Stage() Stage {
	if m.Annotations == nil {
		return "<default>"
	}
	s := m.Annotations["stage"]
	if s == "" {
		return "<default>"
	}
	return Stage(s)
}

type EnvMode string

const (
	ModeShadow EnvMode = "shadow"
	ModeNoop   EnvMode = "noop"
	ModeReal   EnvMode = "real"
)

// EnvMode returns environment mode according to annotations
func (m *Meta) EnvMode() EnvMode {
	a := m.Annotations
	if len(a) == 0 {
		return ModeReal
	}
	mode, ok := a["env.mode"]
	// Case: annotations["env.mode"] = "xxx"
	if ok {
		switch m := EnvMode(mode); m {
		case ModeShadow:
			return ModeShadow
		case ModeNoop:
			return ModeNoop
		case ModeReal:
			fallthrough
		default:
			return ModeReal
		}
	}
	// Case: annotations["env.X"] = "True
	if a["env.noop"] == "True" {
		return ModeNoop
	}
	if a["env.shadow"] == "True" {
		return ModeShadow
	}
	return ModeReal
}

/* Unit metadata derived from incoming template */
type RevisionMeta struct {
	*pb.RevisionMeta
}

func RevisionMetaFromProto(m *pb.RevisionMeta) *RevisionMeta {
	if m == nil {
		m = &pb.RevisionMeta{}
	}
	return &RevisionMeta{m}
}
