package slot

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/stretchr/testify/assert"
	"strconv"
	"testing"
)

func TestGetEnvMode(t *testing.T) {
	type initFun func(m *pb.SlotMeta)

	type testCase struct {
		init     initFun
		expected EnvMode
	}
	tests := []testCase{
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations = nil
			},
			expected: ModeReal,
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations["env.mode"] = "real"
			},
			expected: ModeReal,
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations["env.mode"] = "surreal"
			},
			expected: ModeReal,
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations["env.noop"] = "True"
			},
			expected: ModeNoop,
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations["env.shadow"] = "True"
			},
			expected: ModeShadow,
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations["env.shadow"] = "False"
			},
			expected: ModeReal,
		},
	}
	for i, tt := range tests {
		m := &pb.SlotMeta{
			Annotations: map[string]string{},
		}
		t.Run(strconv.Itoa(i), func(t *testing.T) {
			tt.init(m)
			assert.Equal(t, tt.expected, MetaFromProto(m).EnvMode())
		})
	}
}

func TestMeta_Stage(t *testing.T) {
	type initFun func(m *pb.SlotMeta)

	type testCase struct {
		init     initFun
		expected Stage
	}
	tests := []testCase{
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations = nil
			},
			expected: Stage("<default>"),
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations = make(map[string]string)
			},
			expected: Stage("<default>"),
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations = map[string]string{"stage": ""}
			},
			expected: Stage("<default>"),
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations = map[string]string{"stage": "prestable"}
			},
			expected: Stage("prestable"),
		},
		{
			init: func(m *pb.SlotMeta) {
				m.Annotations = map[string]string{"stage": "stable"}
			},
			expected: Stage("stable"),
		},
	}
	for i, tt := range tests {
		m := &pb.SlotMeta{
			Annotations: map[string]string{},
		}
		t.Run(strconv.Itoa(i), func(t *testing.T) {
			tt.init(m)
			assert.Equal(t, tt.expected, MetaFromProto(m).Stage())
		})
	}
}
