package slot

import (
	"a.yandex-team.ru/infra/hostctl/internal/unit"
	"a.yandex-team.ru/infra/hostctl/internal/unit/kind"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func NewRevision(rev *pb.Rev) *Rev {
	return &Rev{rev: rev}
}

func RevisionFromUnit(u *unit.Unit, meta *pb.RevisionMeta) *Rev {
	rev := &pb.Rev{
		Id:     u.ID(),
		Target: pb.RevisionTarget_CURRENT,
		Meta:   meta,
	}
	switch u.Kind() {
	case kind.PackageSet:
		rev.Spec = &pb.Rev_PackageSet{PackageSet: u.Spec().(*pb.PackageSetSpec)}
	case kind.PortoDaemon:
		rev.Spec = &pb.Rev_PortoDaemon{PortoDaemon: u.Spec().(*pb.PortoDaemon)}
	case kind.SystemService:
		rev.Spec = &pb.Rev_SystemService{SystemService: u.Spec().(*pb.SystemServiceSpec)}
	case kind.TimerJob:
		rev.Spec = &pb.Rev_TimerJob{TimerJob: u.Spec().(*pb.TimerJobSpec)}
	case kind.HostPod:
		rev.Spec = &pb.Rev_Pod{Pod: u.Pod()}
	}
	return NewRevision(rev)
}

type Rev struct {
	rev *pb.Rev
}

func (p *Rev) ID() string {
	return p.rev.Id
}

func (p *Rev) Meta() *RevisionMeta {
	return RevisionMetaFromProto(p.rev.Meta)
}

func (p *Rev) Kind() kind.Kind {
	return kind.Kind(p.rev.Meta.Kind)
}

func (p *Rev) Proto() *pb.Rev {
	return p.rev
}
