package slot

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/golang/protobuf/ptypes"
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestResetPending(t *testing.T) {
	type args struct {
		slot *pb.Slot
	}
	now := ptypes.TimestampNow()
	tests := []struct {
		name string
		args args
		want *Status
	}{{
		name: "new slot reseting pending status to False",
		args: args{
			slot: &pb.Slot{
				Status: &pb.SlotStatus{
					Pending: &pb.Condition{
						Status:         "True",
						Message:        "Some steps failed on prev iteration",
						TransitionTime: now,
					},
				},
			},
		},
		want: (*Status)(&pb.SlotStatus{
			Pending: &pb.Condition{
				Status:         "False",
				Message:        "",
				TransitionTime: now,
			}},
		),
	}}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got := NewSlot(tt.args.slot)
			got.ResetPending()
			assert.Equal(t, tt.want.Pending.Status, got.Status().Pending.Status)
			assert.NotEqual(t, tt.want.Pending.TransitionTime, got.Status().Pending.TransitionTime)
			assert.Equal(t, tt.want.Pending.Message, got.Status().Pending.Message)
		})
	}
}
