package slot

import (
	"a.yandex-team.ru/infra/hostctl/pkg/pbutil"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func (s *Status) Ok() bool {
	return s.IsReady() && (!s.IsPending() || (s.IsPending() && s.IsThrottled()))
}

func (s *Status) IsPending() bool {
	return s.Pending.Status == "True"
}

func (s *Status) SetPending(reason string) {
	pbutil.TrueCond(s.Pending, reason)
}

func (s *Status) SetNotPending() {
	pbutil.FalseCond(s.Pending, "")
}

func (s *Status) IsReady() bool {
	return s.Ready.Status == "True"
}

func (s *Status) SetReady(reason string) {
	pbutil.TrueCond(s.Ready, reason)
}

func (s *Status) SetNotReady() {
	pbutil.FalseCond(s.Ready, "")
}

func (s *Status) IsRemoved() bool {
	return s.Removed.Status == "True"
}

func (s *Status) SetRemoved(reason string) {
	pbutil.TrueCond(s.Removed, reason)
}

func (s *Status) SetNotRemoved() {
	pbutil.FalseCond(s.Removed, "")
}

func (s *Status) IsThrottled() bool {
	return s.Throttled.Status == "True"
}

func (s *Status) SetThrottled(reason string) {
	pbutil.TrueCond(s.Throttled, reason)
}

func (s *Status) SetNotThrottled() {
	pbutil.FalseCond(s.Throttled, "")
}

func (s *Status) IsChanged() bool {
	return s.Changed.Status == "True"
}

func (s *Status) SetChanged(reason string) {
	pbutil.TrueCond(s.Changed, reason)
}

func (s *Status) SetNotChanged() {
	pbutil.FalseCond(s.Changed, "")
}

func (s *Status) IsConflicted() bool {
	return s.Conflicted.Status == "True"
}

func (s *Status) SetConflicted(reason string) {
	pbutil.TrueCond(s.Conflicted, reason)
}

func (s *Status) SetNotConflicted() {
	pbutil.FalseCond(s.Conflicted, "")
}

func (s *Status) IsInstalled() bool {
	return s.Installed.Status == "True"
}

func (s *Status) SetInstalled(reason string) {
	pbutil.TrueCond(s.Installed, reason)
}

func (s *Status) SetNotInstalled() {
	pbutil.FalseCond(s.Installed, "")
}

func (s *Status) IsRunning() bool {
	return s.Running.Status == "True"
}

func (s *Status) SetRunning(reason string) {
	pbutil.TrueCond(s.Running, reason)
}

func (s *Status) SetNotRunning() {
	pbutil.FalseCond(s.Running, "")
}

func (s *Status) Proto() *pb.SlotStatus {
	return (*pb.SlotStatus)(s)
}
