package slot

import (
	"testing"

	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func TestStatus_IsPending(t *testing.T) {
	s := Status{Pending: &pb.Condition{Status: "True"}}
	if !s.IsPending() {
		t.Fail()
	}
	s.Pending.Status = "False"
	if s.IsPending() {
		t.Fail()
	}
	s.Pending.Status = "blah"
	if s.IsPending() {
		t.Fail()
	}
}

func TestStatus_SetPending(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetPending("message")
	if !s.IsPending() || s.Pending.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotPending(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetPending("message")
	s.SetNotPending()
	if s.IsPending() || s.Pending.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsReady(t *testing.T) {
	s := Status{Ready: &pb.Condition{Status: "True"}}
	if !s.IsReady() {
		t.Fail()
	}
	s.Ready.Status = "False"
	if s.IsReady() {
		t.Fail()
	}
	s.Ready.Status = "blah"
	if s.IsReady() {
		t.Fail()
	}
}

func TestStatus_SetReady(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetReady("message")
	if !s.IsReady() || s.Ready.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotReady(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetReady("message")
	s.SetNotReady()
	if s.IsReady() || s.Ready.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsRemoved(t *testing.T) {
	s := Status{Removed: &pb.Condition{Status: "True"}}
	if !s.IsRemoved() {
		t.Fail()
	}
	s.Removed.Status = "False"
	if s.IsRemoved() {
		t.Fail()
	}
	s.Removed.Status = "blah"
	if s.IsRemoved() {
		t.Fail()
	}
}

func TestStatus_SetRemoved(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetRemoved("message")
	if !s.IsRemoved() || s.Removed.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotRemoved(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetRemoved("message")
	s.SetNotRemoved()
	if s.IsRemoved() || s.Removed.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsThrottled(t *testing.T) {
	s := Status{Throttled: &pb.Condition{Status: "True"}}
	if !s.IsThrottled() {
		t.Fail()
	}
	s.Throttled.Status = "False"
	if s.IsThrottled() {
		t.Fail()
	}
	s.Throttled.Status = "blah"
	if s.IsThrottled() {
		t.Fail()
	}
}

func TestStatus_SetThrottled(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetThrottled("message")
	if !s.IsThrottled() || s.Throttled.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotThrottled(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetThrottled("message")
	s.SetNotThrottled()
	if s.IsThrottled() || s.Throttled.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsChanged(t *testing.T) {
	s := Status{Changed: &pb.Condition{Status: "True"}}
	if !s.IsChanged() {
		t.Fail()
	}
	s.Changed.Status = "False"
	if s.IsChanged() {
		t.Fail()
	}
	s.Changed.Status = "blah"
	if s.IsChanged() {
		t.Fail()
	}
}

func TestStatus_SetChanged(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetChanged("message")
	if !s.IsChanged() || s.Changed.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotChanged(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetChanged("message")
	s.SetNotChanged()
	if s.IsChanged() || s.Changed.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsConflicted(t *testing.T) {
	s := Status{Conflicted: &pb.Condition{Status: "True"}}
	if !s.IsConflicted() {
		t.Fail()
	}
	s.Conflicted.Status = "False"
	if s.IsConflicted() {
		t.Fail()
	}
	s.Conflicted.Status = "blah"
	if s.IsConflicted() {
		t.Fail()
	}
}

func TestStatus_SetConflicted(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetConflicted("message")
	if !s.IsConflicted() || s.Conflicted.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotConflicted(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetConflicted("message")
	s.SetNotConflicted()
	if s.IsConflicted() || s.Conflicted.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsInstalled(t *testing.T) {
	s := Status{Installed: &pb.Condition{Status: "True"}}
	if !s.IsInstalled() {
		t.Fail()
	}
	s.Installed.Status = "False"
	if s.IsInstalled() {
		t.Fail()
	}
	s.Installed.Status = "blah"
	if s.IsInstalled() {
		t.Fail()
	}
}

func TestStatus_SetInstalled(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetInstalled("message")
	if !s.IsInstalled() || s.Installed.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotInstalled(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetInstalled("message")
	s.SetNotInstalled()
	if s.IsInstalled() || s.Installed.Message != "" {
		t.Fail()
	}
}

func TestStatus_IsRunning(t *testing.T) {
	s := Status{Running: &pb.Condition{Status: "True"}}
	if !s.IsRunning() {
		t.Fail()
	}
	s.Running.Status = "False"
	if s.IsRunning() {
		t.Fail()
	}
	s.Running.Status = "blah"
	if s.IsRunning() {
		t.Fail()
	}
}

func TestStatus_SetRunning(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetRunning("message")
	if !s.IsRunning() || s.Running.Message != "message" {
		t.Fail()
	}
}

func TestStatus_SetNotRunning(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetRunning("message")
	s.SetNotRunning()
	if s.IsRunning() || s.Running.Message != "" {
		t.Fail()
	}
}

func TestStatus_Ok(t *testing.T) {
	s := NewEmptySlotStatus()
	s.SetReady("ready")
	s.SetPending("pending")
	s.SetThrottled("throttled")
	if !s.Ok() {
		t.Fail()
	}
	s.SetNotThrottled()
	if s.Ok() {
		t.Fail()
	}
	s.SetNotPending()
	if !s.Ok() {
		t.Fail()
	}
	s.SetNotReady()
	if s.Ok() {
		t.Fail()
	}
}
