package systemd

import (
	"context"

	"github.com/stretchr/testify/mock"
)

func NewFake() *Fake {
	return &Fake{}
}

type Fake struct {
	mock.Mock
}

func (f *Fake) Enable(unit *Unit) error {
	args := f.Called(unit)
	return args.Error(0)
}

func (f *Fake) Disable(unit *Unit) error {
	args := f.Called(unit)
	return args.Error(0)
}

func (f *Fake) Restart(ctx context.Context, unit *Unit, revID string) error {
	args := f.Called(ctx, unit, revID)
	return args.Error(0)
}

func (f *Fake) Reload(ctx context.Context, unit *Unit, revID string) error {
	args := f.Called(ctx, unit, revID)
	return args.Error(0)
}

func (f *Fake) Start(ctx context.Context, unit *Unit, revID string) error {
	args := f.Called(ctx, unit, revID)
	return args.Error(0)
}

func (f *Fake) Stop(ctx context.Context, unit *Unit) error {
	args := f.Called(ctx, unit)
	return args.Error(0)
}

func (f *Fake) Status(unit *Unit, revID string) (*UnitStatus, error) {
	args := f.Called(unit, revID)
	return args.Get(0).(*UnitStatus), args.Error(1)
}

func (f *Fake) ReloadDaemon() error {
	args := f.Called()
	return args.Error(0)
}
