package systemd

import (
	"context"
)

func NewNoopSystemd(real Systemd) Systemd {
	return &noop{real: real}
}

type noop struct {
	real Systemd
}

func (s *noop) Restart(ctx context.Context, u *Unit, revID string) error {
	return nil
}

func (s *noop) Reload(ctx context.Context, u *Unit, revID string) error {
	return nil
}

func (s *noop) Start(ctx context.Context, u *Unit, revID string) error {
	return nil
}

func (s *noop) Stop(ctx context.Context, unit *Unit) error {
	return nil
}

func (s *noop) Enable(*Unit) error {
	return nil
}

func (s *noop) Disable(*Unit) error {
	return nil
}

func (s *noop) Status(unit *Unit, revID string) (*UnitStatus, error) {
	return s.real.Status(unit, revID)
}

func (s *noop) ReloadDaemon() error {
	return nil
}
