package persist

import "github.com/stretchr/testify/mock"

func NewFake() *Fake {
	return &Fake{}
}

type Fake struct {
	mock.Mock
}

func (f *Fake) IsCurrent(name, revID string) (bool, error) {
	args := f.Called(name, revID)
	return args.Bool(0), args.Error(1)
}

func (f *Fake) SaveRevision(name, revID string) error {
	args := f.Called(name, revID)
	return args.Error(0)
}

func (f *Fake) RemoveRevision(name string) error {
	args := f.Called(name)
	return args.Error(0)
}
